/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2artifacts.content.effects.attribute;

import dev.xkmc.l2artifacts.content.config.ArtifactSetConfig;
import dev.xkmc.l2artifacts.content.effects.attribute.AbstractConditionalAttributeSetEffect;
import dev.xkmc.l2artifacts.content.effects.attribute.AttrSetEntry;
import dev.xkmc.l2artifacts.content.effects.attribute.TimedCAData;
import dev.xkmc.l2artifacts.init.registrate.entries.LinearFuncEntry;
import dev.xkmc.l2library.capability.conditionals.ConditionalData;
import dev.xkmc.l2library.capability.conditionals.Context;
import dev.xkmc.l2library.capability.conditionals.TokenProvider;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class TimedCASetEffect
extends AbstractConditionalAttributeSetEffect<TimedCAData> {
    private final Predicate<Player> pred;
    private final LinearFuncEntry period;

    public TimedCASetEffect(Predicate<Player> pred, LinearFuncEntry period, AttrSetEntry ... entries) {
        super(entries);
        this.pred = pred;
        this.period = period;
    }

    @Override
    public void tick(Player player, ArtifactSetConfig.Entry ent, int rank, boolean enabled) {
        if (!enabled) {
            return;
        }
        TimedCAData data = (TimedCAData)((ConditionalData)ConditionalData.HOLDER.get(player)).getOrCreateData((TokenProvider)this, (Context)ent);
        data.update(2, rank);
        if (!this.pred.test(player)) {
            data.time = 0;
            data.remove(player);
        } else {
            ++data.time;
            if ((double)data.time > this.period.getFromRank(rank)) {
                this.addAttributes(player, ent, rank, data);
            }
        }
    }

    @Override
    protected MutableComponent getConditionText(int rank) {
        double time = (double)Math.round(this.period.getFromRank(rank)) / 20.0;
        return Component.m_237110_((String)(this.getDescriptionId() + ".desc"), (Object[])new Object[]{time});
    }

    @Override
    protected TimedCAData getData() {
        return new TimedCAData();
    }
}

